import { create } from 'zustand';

// Mock initial data
const initialData = {
  clientes: [{ id: 1, nome: 'Empresa ABC', email: 'contato@abc.com', telefone: '1199999999' }],
  produtos: [{ id: 1, nome: 'Teclado Mecânico', preco: 250.00, estoque: 15 }],
  pedidos_venda: [],
  itens_venda: [],
  pagamentos_venda: [],
  fornecedores: [{ id: 1, nome: 'Distribuidora Tech', contato: 'vendas@tech.com' }],
  contas_pagar: [],
  movimentacoes_estoque: [],
  pedidos_compra: [],
  itens_compra: []
};

export const useStore = create((set) => ({
  user: null,
  data: initialData,
  
  login: (email) => set({ user: { email, name: 'Admin' } }),
  logout: () => set({ user: null }),

  addItem: (module, item) => set((state) => ({
    data: {
      ...state.data,
      [module]: [...state.data[module], { ...item, id: Date.now() }]
    }
  })),

  updateItem: (module, id, updatedItem) => set((state) => ({
    data: {
      ...state.data,
      [module]: state.data[module].map((item) => item.id === id ? { ...item, ...updatedItem } : item)
    }
  })),

  deleteItem: (module, id) => set((state) => ({
    data: {
      ...state.data,
      [module]: state.data[module].filter((item) => item.id !== id)
    }
  }))
}));