import React, { useState } from 'react';
import { useStore } from '../store/useStore';
import { useNavigate } from 'react-router-dom';
import { Package, ArrowRight } from 'lucide-react';

export default function Login() {
  const [email, setEmail] = useState('');
  const login = useStore((state) => state.login);
  const navigate = useNavigate();

  const handleSubmit = (e) => {
    e.preventDefault();
    login(email);
    navigate('/');
  };

  return (
    <div className="flex min-h-screen bg-white">
      {/* Left Side - Form */}
      <div className="w-full md:w-1/2 flex flex-col justify-center px-12 lg:px-24 py-12">
        <div className="mb-12">
            <div className="w-10 h-10 bg-primary rounded-lg flex items-center justify-center mb-4">
                <Package className="text-white" size={24} />
            </div>
            <h1 className="text-3xl font-bold text-gray-900 mb-2">Bem-vindo de volta</h1>
            <p className="text-gray-500">Entre com suas credenciais para acessar o Estoque Pro.</p>
        </div>

        <form onSubmit={handleSubmit} className="space-y-6">
          <div>
            <label className="block text-sm font-medium text-gray-700 mb-1">Email Corporativo</label>
            <input
              type="email"
              required
              className="w-full px-4 py-3 border border-gray-200 rounded-lg focus:ring-2 focus:ring-primary focus:border-transparent outline-none transition-all"
              placeholder="seu@email.com"
              value={email}
              onChange={(e) => setEmail(e.target.value)}
            />
          </div>
          <div>
            <label className="block text-sm font-medium text-gray-700 mb-1">Senha</label>
            <input
              type="password"
              required
              className="w-full px-4 py-3 border border-gray-200 rounded-lg focus:ring-2 focus:ring-primary focus:border-transparent outline-none transition-all"
              placeholder="••••••••"
            />
          </div>
          
          <button
            type="submit"
            className="w-full bg-primary hover:bg-primaryDark text-white font-medium py-3 rounded-lg transition-colors flex items-center justify-center gap-2 group"
          >
            Acessar Sistema
            <ArrowRight size={18} className="group-hover:translate-x-1 transition-transform" />
          </button>
        </form>

        <p className="mt-8 text-center text-sm text-gray-500">
          Não tem acesso? <a href="#" className="text-primary hover:underline">Contate o administrador</a>
        </p>
      </div>

      {/* Right Side - Visual */}
      <div className="hidden md:flex md:w-1/2 bg-slate-900 relative overflow-hidden items-center justify-center p-12">
        <div className="absolute inset-0 bg-gradient-to-br from-primary/30 to-purple-900/30" />
        <div className="relative z-10 max-w-lg text-center">
            <h2 className="text-4xl font-bold text-white mb-6 leading-tight">Gestão Inteligente para o seu Negócio</h2>
            <p className="text-slate-300 text-lg">Controle total de estoque, vendas e financeiro em uma única plataforma unificada e moderna.</p>
        </div>
        {/* Abstract circles decoration */}
        <div className="absolute -bottom-24 -left-24 w-64 h-64 bg-primary/20 rounded-full blur-3xl" />
        <div className="absolute top-12 right-12 w-32 h-32 bg-purple-500/20 rounded-full blur-2xl" />
      </div>
    </div>
  );
}