import React from 'react';
import { TrendingUp, Package, Users, DollarSign } from 'lucide-react';
import { useStore } from '../store/useStore';

const StatCard = ({ title, value, icon: Icon, trend, color }) => (
  <div className="bg-white p-6 rounded-xl shadow-sm border border-gray-100">
    <div className="flex justify-between items-start">
      <div>
        <p className="text-gray-500 text-sm font-medium mb-1">{title}</p>
        <h3 className="text-2xl font-bold text-gray-800">{value}</h3>
      </div>
      <div className={`p-2 rounded-lg ${color}`}>
        <Icon size={20} className="text-white" />
      </div>
    </div>
    <div className="mt-4 flex items-center text-sm text-green-600">
        <TrendingUp size={16} className="mr-1" />
        <span className="font-medium">{trend}</span>
        <span className="text-gray-400 ml-1">vs mês anterior</span>
    </div>
  </div>
);

export default function Dashboard() {
  const data = useStore(state => state.data);

  return (
    <div className="p-8">
      <h1 className="text-2xl font-bold text-gray-800 mb-8">Visão Geral</h1>
      
      <div className="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-4 gap-6 mb-8">
        <StatCard 
            title="Vendas Totais" 
            value="R$ 124.500" 
            icon={DollarSign} 
            trend="+12.5%" 
            color="bg-green-500" 
        />
        <StatCard 
            title="Novos Clientes" 
            value={data.clientes.length} 
            icon={Users} 
            trend="+5.2%" 
            color="bg-blue-500" 
        />
        <StatCard 
            title="Produtos" 
            value={data.produtos.length} 
            icon={Package} 
            trend="+2.4%" 
            color="bg-orange-500" 
        />
        <StatCard 
            title="Pedidos Ativos" 
            value="18" 
            icon={Package} 
            trend="+8.1%" 
            color="bg-purple-500" 
        />
      </div>

      <div className="grid grid-cols-1 lg:grid-cols-2 gap-8">
        <div className="bg-white p-6 rounded-xl shadow-sm border border-gray-100">
            <h3 className="font-bold text-gray-800 mb-4">Vendas Recentes</h3>
            <div className="h-64 flex items-center justify-center text-gray-400 bg-gray-50 rounded-lg">
                Gráfico de Vendas (Simulação)
            </div>
        </div>
        <div className="bg-white p-6 rounded-xl shadow-sm border border-gray-100">
            <h3 className="font-bold text-gray-800 mb-4">Estoque Baixo</h3>
            <div className="space-y-4">
                {data.produtos.slice(0, 3).map(p => (
                    <div key={p.id} className="flex items-center justify-between p-3 bg-gray-50 rounded-lg">
                        <div>
                            <p className="font-medium text-gray-800">{p.nome}</p>
                            <p className="text-sm text-gray-500">SKU: 00{p.id}</p>
                        </div>
                        <span className="px-2 py-1 bg-red-100 text-red-700 rounded text-xs font-bold">
                            {p.estoque} un
                        </span>
                    </div>
                ))}
            </div>
        </div>
      </div>
    </div>
  );
}