import React from 'react';
import { Link, useLocation } from 'react-router-dom';
import { 
  LayoutDashboard, Users, Package, ShoppingCart, Archive, DollarSign, 
  Truck, Receipt, Activity, ShoppingBag, List, LogOut 
} from 'lucide-react';
import { useStore } from '../store/useStore';

const menuItems = [
  { path: '/', icon: LayoutDashboard, label: 'Dashboard' },
  { path: '/clientes', icon: Users, label: 'Clientes' },
  { path: '/produtos', icon: Package, label: 'Produtos' },
  { path: '/pedidos-venda', icon: ShoppingCart, label: 'Pedidos Venda' },
  { path: '/itens-venda', icon: List, label: 'Itens Venda' },
  { path: '/pagamentos-venda', icon: DollarSign, label: 'Pagamentos' },
  { path: '/fornecedores', icon: Truck, label: 'Fornecedores' },
  { path: '/contas-pagar', icon: Receipt, label: 'Contas a Pagar' },
  { path: '/movimentacoes', icon: Activity, label: 'Mov. Estoque' },
  { path: '/pedidos-compra', icon: ShoppingBag, label: 'Pedidos Compra' },
  { path: '/itens-compra', icon: Archive, label: 'Itens Compra' },
];

export default function Sidebar() {
  const location = useLocation();
  const logout = useStore(state => state.logout);

  return (
    <div className="w-64 h-screen bg-white border-r border-gray-200 flex flex-col">
      <div className="p-6 border-b border-gray-100 flex items-center gap-2">
        <div className="w-8 h-8 bg-primary rounded-lg flex items-center justify-center">
          <Package className="text-white" size={20} />
        </div>
        <span className="font-bold text-xl text-gray-800 tracking-tight">Estoque Pro</span>
      </div>
      
      <nav className="flex-1 overflow-y-auto p-4 space-y-1">
        {menuItems.map((item) => {
          const Icon = item.icon;
          const isActive = location.pathname === item.path;
          return (
            <Link
              key={item.path}
              to={item.path}
              className={`flex items-center gap-3 px-4 py-3 rounded-lg text-sm font-medium transition-all ${
                isActive 
                  ? 'bg-blue-50 text-primary shadow-sm' 
                  : 'text-gray-600 hover:bg-gray-50 hover:text-gray-900'
              }`}
            >
              <Icon size={18} />
              {item.label}
            </Link>
          );
        })}
      </nav>

      <div className="p-4 border-t border-gray-100">
        <button 
          onClick={logout}
          className="flex items-center gap-3 w-full px-4 py-3 text-red-600 hover:bg-red-50 rounded-lg text-sm font-medium transition-colors"
        >
          <LogOut size={18} />
          Sair do Sistema
        </button>
      </div>
    </div>
  );
}