import React from 'react';
import { Bell, User } from 'lucide-react';
import { useStore } from '../store/useStore';

export default function Header() {
  const user = useStore(state => state.user);

  return (
    <header className="bg-white border-b border-gray-200 h-16 flex items-center justify-between px-8">
      <h2 className="text-gray-500 text-sm font-medium">Bem-vindo ao Painel de Controle</h2>
      <div className="flex items-center gap-4">
        <button className="p-2 text-gray-400 hover:text-primary transition-colors relative">
            <Bell size={20} />
            <span className="absolute top-2 right-2 w-2 h-2 bg-red-500 rounded-full"></span>
        </button>
        <div className="flex items-center gap-3 pl-4 border-l border-gray-100">
            <div className="text-right">
                <p className="text-sm font-medium text-gray-800">{user?.name || 'Usuário'}</p>
                <p className="text-xs text-gray-500">Administrador</p>
            </div>
            <div className="w-10 h-10 bg-gray-100 rounded-full flex items-center justify-center text-gray-600">
                <User size={20} />
            </div>
        </div>
      </div>
    </header>
  );
}