import React from 'react';
import { BrowserRouter, Routes, Route, Navigate } from 'react-router-dom';
import { useStore } from './store/useStore';
import Layout from './components/Layout';
import Login from './pages/Login';
import Dashboard from './pages/Dashboard';
import ClientesPage from './pages/clientes';
import ProdutosPage from './pages/produtos';
import PedidosVendaPage from './pages/pedidos_venda';
import ItensVendaPage from './pages/itens_venda';
import PagamentosVendaPage from './pages/pagamentos_venda';
import FornecedoresPage from './pages/fornecedores';
import ContasPagarPage from './pages/contas_pagar';
import MovimentacoesPage from './pages/movimentacoes_estoque';
import PedidosCompraPage from './pages/pedidos_compra';
import ItensCompraPage from './pages/itens_compra';

const ProtectedRoute = ({ children }) => {
  const user = useStore((state) => state.user);
  if (!user) return <Navigate to="/login" replace />;
  return children;
};

function App() {
  return (
    <BrowserRouter>
      <Routes>
        <Route path="/login" element={<Login />} />
        <Route path="/" element={<ProtectedRoute><Layout /></ProtectedRoute>}>
          <Route index element={<Dashboard />} />
          <Route path="clientes" element={<ClientesPage />} />
          <Route path="produtos" element={<ProdutosPage />} />
          <Route path="pedidos-venda" element={<PedidosVendaPage />} />
          <Route path="itens-venda" element={<ItensVendaPage />} />
          <Route path="pagamentos-venda" element={<PagamentosVendaPage />} />
          <Route path="fornecedores" element={<FornecedoresPage />} />
          <Route path="contas-pagar" element={<ContasPagarPage />} />
          <Route path="movimentacoes" element={<MovimentacoesPage />} />
          <Route path="pedidos-compra" element={<PedidosCompraPage />} />
          <Route path="itens-compra" element={<ItensCompraPage />} />
        </Route>
      </Routes>
    </BrowserRouter>
  );
}

export default App;